/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.Security;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;
import xjava.security.VariableLengthDigest;

public class HAVAL
extends MessageDigest
implements Parameterized,
VariableLengthDigest,
Cloneable {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("HAVAL");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("HAVAL", 2, 3);
    private static final int VERSION = 1;
    private static final int DEFAULT_PASSES = 3;
    private static final int DEFAULT_BITLENGTH = 256;
    private static final int BLOCK_LENGTH = 128;
    private static final int CONTEXT_LENGTH = 8;
    private boolean native_ok;
    private int passes = 3;
    private int bitLength = 256;
    private long count;
    private int[] context = new int[8];
    private byte[] buffer = new byte[128];
    private int[] X = new int[32];

    private static void debug(String string) {
        err.println("HAVAL: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(HAVAL.getLibMajorVersion(), HAVAL.getLibMinorVersion());
                    }
                    if (linkStatus.useNative()) {
                        this.native_ok = true;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    HAVAL.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                HAVAL.debug("Using native library? " + this.native_ok);
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private static native String native_hash(int[] var0, byte[] var1, int var2, int var3);

    public Object clone() {
        return new HAVAL(this);
    }

    protected void engineReset() {
        this.context[0] = 608135816;
        this.context[1] = -2052912941;
        this.context[2] = 320440878;
        this.context[3] = 57701188;
        this.context[4] = -1542899678;
        this.context[5] = 698298832;
        this.context[6] = 137296536;
        this.context[7] = -330404727;
        this.count = 0L;
        int n2 = 0;
        while (n2 < 128) {
            this.buffer[n2] = 0;
            ++n2;
        }
    }

    protected void engineUpdate(byte by) {
        int n2 = (int)(this.count % 128L);
        ++this.count;
        this.buffer[n2] = by;
        if (n2 == 127) {
            this.transform(this.buffer, 0);
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || (long)n2 + (long)n3 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = (int)(this.count % 128L);
        this.count += (long)n3;
        int n5 = 128 - n4;
        int n6 = 0;
        if (n3 >= n5) {
            System.arraycopy(byArray, n2, this.buffer, n4, n5);
            this.transform(this.buffer, 0);
            n6 = n5;
            while (n6 + 128 - 1 < n3) {
                this.transform(byArray, n2 + n6);
                n6 += 128;
            }
            n4 = 0;
        }
        if (n6 < n3) {
            System.arraycopy(byArray, n2 + n6, this.buffer, n4, n3 - n6);
        }
    }

    protected byte[] engineDigest() {
        int n2 = (int)(this.count % 128L);
        int n3 = n2 < 118 ? 118 - n2 : 246 - n2;
        byte[] byArray = new byte[n3 + 10];
        byArray[0] = 1;
        byArray[n3] = (byte)((this.bitLength & 3) << 6 | (this.passes & 7) << 3 | 1);
        byArray[n3 + 1] = (byte)(this.bitLength >>> 2);
        int n4 = 0;
        while (n4 < 8) {
            byArray[n3 + 2 + n4] = (byte)(this.count * 8L >>> 8 * n4);
            ++n4;
        }
        this.engineUpdate(byArray, 0, byArray.length);
        this.tailorDigestBits();
        byte[] byArray2 = new byte[this.bitLength / 8];
        int n5 = 0;
        while (n5 < this.bitLength / 32) {
            int n6 = 0;
            while (n6 < 4) {
                byArray2[n5 * 4 + n6] = (byte)(this.context[n5] >>> 8 * n6);
                ++n6;
            }
            ++n5;
        }
        this.engineReset();
        return byArray2;
    }

    protected int engineGetDigestLength() {
        return this.bitLength / 8;
    }

    public void setParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        return this.engineGetParameter(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("passes")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("passes.HAVAL");
            this.setPasses((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("bitLength")) throw new NoSuchParameterException(string + ".HAVAL");
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("bitLength.HAVAL");
            this.setBitLength((Integer)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("passes")) {
            return new Integer(this.passes);
        }
        if (string.equalsIgnoreCase("bitLength")) {
            return new Integer(this.bitLength);
        }
        throw new NoSuchParameterException(string + ".HAVAL");
    }

    public void setPasses(int n2) {
        if (n2 < 3 || n2 > 5) {
            throw new InvalidParameterException();
        }
        this.passes = n2;
        this.engineReset();
    }

    public void setBitLength(int n2) {
        if (n2 % 32 != 0 || n2 < 128 || n2 > 256) {
            throw new InvalidParameterException();
        }
        this.bitLength = n2;
        this.engineReset();
    }

    public void setDigestLength(int n2) {
        this.setBitLength(n2 * 8);
    }

    private void transform(byte[] byArray, int n2) {
        if (this.native_ok) {
            if (this.context.length != 8 || n2 < 0 || (long)n2 + 128L > (long)byArray.length) {
                throw new InternalError(this.getAlgorithm() + ": context.length != " + "8" + " || offset < 0 || " + "(long)offset + " + "128" + " > block.length");
            }
            linkStatus.check(HAVAL.native_hash(this.context, byArray, n2, this.passes));
            return;
        }
        int n3 = 0;
        while (n3 < 32) {
            this.X[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            ++n3;
        }
        n3 = this.context[0];
        int n4 = this.context[1];
        int n5 = this.context[2];
        int n6 = this.context[3];
        int n7 = this.context[4];
        int n8 = this.context[5];
        int n9 = this.context[6];
        int n10 = this.context[7];
        n10 = this.FF_1(n10, n9, n8, n7, n6, n5, n4, n3, this.X[0]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n10, this.X[1]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n10, n9, this.X[2]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n10, n9, n8, this.X[3]);
        n6 = this.FF_1(n6, n5, n4, n3, n10, n9, n8, n7, this.X[4]);
        n5 = this.FF_1(n5, n4, n3, n10, n9, n8, n7, n6, this.X[5]);
        n4 = this.FF_1(n4, n3, n10, n9, n8, n7, n6, n5, this.X[6]);
        n3 = this.FF_1(n3, n10, n9, n8, n7, n6, n5, n4, this.X[7]);
        n10 = this.FF_1(n10, n9, n8, n7, n6, n5, n4, n3, this.X[8]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n10, this.X[9]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n10, n9, this.X[10]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n10, n9, n8, this.X[11]);
        n6 = this.FF_1(n6, n5, n4, n3, n10, n9, n8, n7, this.X[12]);
        n5 = this.FF_1(n5, n4, n3, n10, n9, n8, n7, n6, this.X[13]);
        n4 = this.FF_1(n4, n3, n10, n9, n8, n7, n6, n5, this.X[14]);
        n3 = this.FF_1(n3, n10, n9, n8, n7, n6, n5, n4, this.X[15]);
        n10 = this.FF_1(n10, n9, n8, n7, n6, n5, n4, n3, this.X[16]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n10, this.X[17]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n10, n9, this.X[18]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n10, n9, n8, this.X[19]);
        n6 = this.FF_1(n6, n5, n4, n3, n10, n9, n8, n7, this.X[20]);
        n5 = this.FF_1(n5, n4, n3, n10, n9, n8, n7, n6, this.X[21]);
        n4 = this.FF_1(n4, n3, n10, n9, n8, n7, n6, n5, this.X[22]);
        n3 = this.FF_1(n3, n10, n9, n8, n7, n6, n5, n4, this.X[23]);
        n10 = this.FF_1(n10, n9, n8, n7, n6, n5, n4, n3, this.X[24]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n10, this.X[25]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n10, n9, this.X[26]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n10, n9, n8, this.X[27]);
        n6 = this.FF_1(n6, n5, n4, n3, n10, n9, n8, n7, this.X[28]);
        n5 = this.FF_1(n5, n4, n3, n10, n9, n8, n7, n6, this.X[29]);
        n4 = this.FF_1(n4, n3, n10, n9, n8, n7, n6, n5, this.X[30]);
        n3 = this.FF_1(n3, n10, n9, n8, n7, n6, n5, n4, this.X[31]);
        n10 = this.FF_2(n10, n9, n8, n7, n6, n5, n4, n3, this.X[5], 1160258022);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n10, this.X[14], 953160567);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n10, n9, this.X[26], -1101764913);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n10, n9, n8, this.X[18], 887688300);
        n6 = this.FF_2(n6, n5, n4, n3, n10, n9, n8, n7, this.X[11], -1062458953);
        n5 = this.FF_2(n5, n4, n3, n10, n9, n8, n7, n6, this.X[28], -914599715);
        n4 = this.FF_2(n4, n3, n10, n9, n8, n7, n6, n5, this.X[7], 1065670069);
        n3 = this.FF_2(n3, n10, n9, n8, n7, n6, n5, n4, this.X[16], -1253635817);
        n10 = this.FF_2(n10, n9, n8, n7, n6, n5, n4, n3, this.X[0], -1843997223);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n10, this.X[23], -1988494565);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n10, n9, this.X[20], -785314906);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n10, n9, n8, this.X[22], -1730169428);
        n6 = this.FF_2(n6, n5, n4, n3, n10, n9, n8, n7, this.X[1], 805139163);
        n5 = this.FF_2(n5, n4, n3, n10, n9, n8, n7, n6, this.X[10], -803545161);
        n4 = this.FF_2(n4, n3, n10, n9, n8, n7, n6, n5, this.X[4], -1193168915);
        n3 = this.FF_2(n3, n10, n9, n8, n7, n6, n5, n4, this.X[8], 1780907670);
        n10 = this.FF_2(n10, n9, n8, n7, n6, n5, n4, n3, this.X[30], -1166241723);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n10, this.X[3], -248741991);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n10, n9, this.X[21], 614570311);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n10, n9, n8, this.X[9], -1282315017);
        n6 = this.FF_2(n6, n5, n4, n3, n10, n9, n8, n7, this.X[17], 134345442);
        n5 = this.FF_2(n5, n4, n3, n10, n9, n8, n7, n6, this.X[24], -2054226922);
        n4 = this.FF_2(n4, n3, n10, n9, n8, n7, n6, n5, this.X[29], 1667834072);
        n3 = this.FF_2(n3, n10, n9, n8, n7, n6, n5, n4, this.X[6], 1901547113);
        n10 = this.FF_2(n10, n9, n8, n7, n6, n5, n4, n3, this.X[19], -1537671517);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n10, this.X[12], -191677058);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n10, n9, this.X[15], 227898511);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n10, n9, n8, this.X[13], 1921955416);
        n6 = this.FF_2(n6, n5, n4, n3, n10, n9, n8, n7, this.X[2], 1904987480);
        n5 = this.FF_2(n5, n4, n3, n10, n9, n8, n7, n6, this.X[25], -2112533778);
        n4 = this.FF_2(n4, n3, n10, n9, n8, n7, n6, n5, this.X[31], 2069144605);
        n3 = this.FF_2(n3, n10, n9, n8, n7, n6, n5, n4, this.X[27], -1034266187);
        n10 = this.FF_3(n10, n9, n8, n7, n6, n5, n4, n3, this.X[19], -1674521287);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n10, this.X[9], 720527379);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n10, n9, this.X[4], -976113629);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n10, n9, n8, this.X[20], 677414384);
        n6 = this.FF_3(n6, n5, n4, n3, n10, n9, n8, n7, this.X[28], -901678824);
        n5 = this.FF_3(n5, n4, n3, n10, n9, n8, n7, n6, this.X[17], -1193592593);
        n4 = this.FF_3(n4, n3, n10, n9, n8, n7, n6, n5, this.X[8], -1904616272);
        n3 = this.FF_3(n3, n10, n9, n8, n7, n6, n5, n4, this.X[22], 1614419982);
        n10 = this.FF_3(n10, n9, n8, n7, n6, n5, n4, n3, this.X[29], 1822297739);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n10, this.X[14], -1340175810);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n10, n9, this.X[25], -686458943);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n10, n9, n8, this.X[12], -1120842969);
        n6 = this.FF_3(n6, n5, n4, n3, n10, n9, n8, n7, this.X[24], 2024746970);
        n5 = this.FF_3(n5, n4, n3, n10, n9, n8, n7, n6, this.X[30], 1432378464);
        n4 = this.FF_3(n4, n3, n10, n9, n8, n7, n6, n5, this.X[16], -430627341);
        n3 = this.FF_3(n3, n10, n9, n8, n7, n6, n5, n4, this.X[26], -1437226092);
        n10 = this.FF_3(n10, n9, n8, n7, n6, n5, n4, n3, this.X[31], 1464375394);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n10, this.X[15], 1676153920);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n10, n9, this.X[7], 1439316330);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n10, n9, n8, this.X[3], 715854006);
        n6 = this.FF_3(n6, n5, n4, n3, n10, n9, n8, n7, this.X[1], -1261675468);
        n5 = this.FF_3(n5, n4, n3, n10, n9, n8, n7, n6, this.X[0], 289532110);
        n4 = this.FF_3(n4, n3, n10, n9, n8, n7, n6, n5, this.X[18], -1588296017);
        n3 = this.FF_3(n3, n10, n9, n8, n7, n6, n5, n4, this.X[27], 2087905683);
        n10 = this.FF_3(n10, n9, n8, n7, n6, n5, n4, n3, this.X[13], -1276242927);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n10, this.X[6], 1668267050);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n10, n9, this.X[21], 732546397);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n10, n9, n8, this.X[10], 1947742710);
        n6 = this.FF_3(n6, n5, n4, n3, n10, n9, n8, n7, this.X[23], -832815594);
        n5 = this.FF_3(n5, n4, n3, n10, n9, n8, n7, n6, this.X[11], -1685613794);
        n4 = this.FF_3(n4, n3, n10, n9, n8, n7, n6, n5, this.X[5], -1344882125);
        n3 = this.FF_3(n3, n10, n9, n8, n7, n6, n5, n4, this.X[2], 1814351708);
        if (this.passes >= 4) {
            n10 = this.FF_4(n10, n9, n8, n7, n6, n5, n4, n3, this.X[24], 2050118529);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n10, this.X[4], 680887927);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n10, n9, this.X[0], 999245976);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n10, n9, n8, this.X[14], 1800124847);
            n6 = this.FF_4(n6, n5, n4, n3, n10, n9, n8, n7, this.X[2], -994056165);
            n5 = this.FF_4(n5, n4, n3, n10, n9, n8, n7, n6, this.X[7], 1713906067);
            n4 = this.FF_4(n4, n3, n10, n9, n8, n7, n6, n5, this.X[28], 1641548236);
            n3 = this.FF_4(n3, n10, n9, n8, n7, n6, n5, n4, this.X[23], -81679983);
            n10 = this.FF_4(n10, n9, n8, n7, n6, n5, n4, n3, this.X[26], 1216130144);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n10, this.X[6], 1575780402);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n10, n9, this.X[30], -276538019);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n10, n9, n8, this.X[20], -377129551);
            n6 = this.FF_4(n6, n5, n4, n3, n10, n9, n8, n7, this.X[18], -601480446);
            n5 = this.FF_4(n5, n4, n3, n10, n9, n8, n7, n6, this.X[25], -345695352);
            n4 = this.FF_4(n4, n3, n10, n9, n8, n7, n6, n5, this.X[19], 596196993);
            n3 = this.FF_4(n3, n10, n9, n8, n7, n6, n5, n4, this.X[3], -745100091);
            n10 = this.FF_4(n10, n9, n8, n7, n6, n5, n4, n3, this.X[22], 258830323);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n10, this.X[11], -2081144263);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n10, n9, this.X[31], 772490370);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n10, n9, n8, this.X[21], -1534844924);
            n6 = this.FF_4(n6, n5, n4, n3, n10, n9, n8, n7, this.X[8], 1774776394);
            n5 = this.FF_4(n5, n4, n3, n10, n9, n8, n7, n6, this.X[27], -1642095778);
            n4 = this.FF_4(n4, n3, n10, n9, n8, n7, n6, n5, this.X[12], 566650946);
            n3 = this.FF_4(n3, n10, n9, n8, n7, n6, n5, n4, this.X[9], -152474470);
            n10 = this.FF_4(n10, n9, n8, n7, n6, n5, n4, n3, this.X[1], 1728879713);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n10, this.X[29], -1412200208);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n10, n9, this.X[5], 1783734482);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n10, n9, n8, this.X[15], -665571480);
            n6 = this.FF_4(n6, n5, n4, n3, n10, n9, n8, n7, this.X[17], -1777359064);
            n5 = this.FF_4(n5, n4, n3, n10, n9, n8, n7, n6, this.X[10], -1420741725);
            n4 = this.FF_4(n4, n3, n10, n9, n8, n7, n6, n5, this.X[16], 1861159788);
            n3 = this.FF_4(n3, n10, n9, n8, n7, n6, n5, n4, this.X[13], 326777828);
        }
        if (this.passes == 5) {
            n10 = this.FF_5(n10, n9, n8, n7, n6, n5, n4, n3, this.X[27], -1170476976);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n10, this.X[3], 2130389656);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n10, n9, this.X[21], -1578015459);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n10, n9, n8, this.X[26], 967770486);
            n6 = this.FF_5(n6, n5, n4, n3, n10, n9, n8, n7, this.X[17], 1724537150);
            n5 = this.FF_5(n5, n4, n3, n10, n9, n8, n7, n6, this.X[11], -2109534584);
            n4 = this.FF_5(n4, n3, n10, n9, n8, n7, n6, n5, this.X[20], -1930525159);
            n3 = this.FF_5(n3, n10, n9, n8, n7, n6, n5, n4, this.X[29], 1164943284);
            n10 = this.FF_5(n10, n9, n8, n7, n6, n5, n4, n3, this.X[19], 2105845187);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n10, this.X[0], 998989502);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n10, n9, this.X[12], -529566248);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n10, n9, n8, this.X[7], -2050940813);
            n6 = this.FF_5(n6, n5, n4, n3, n10, n9, n8, n7, this.X[13], 1075463327);
            n5 = this.FF_5(n5, n4, n3, n10, n9, n8, n7, n6, this.X[8], 1455516326);
            n4 = this.FF_5(n4, n3, n10, n9, n8, n7, n6, n5, this.X[31], 1322494562);
            n3 = this.FF_5(n3, n10, n9, n8, n7, n6, n5, n4, this.X[10], 910128902);
            n10 = this.FF_5(n10, n9, n8, n7, n6, n5, n4, n3, this.X[5], 469688178);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n10, this.X[9], 1117454909);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n10, n9, this.X[14], 936433444);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n10, n9, n8, this.X[30], -804646328);
            n6 = this.FF_5(n6, n5, n4, n3, n10, n9, n8, n7, this.X[18], -619713837);
            n5 = this.FF_5(n5, n4, n3, n10, n9, n8, n7, n6, this.X[6], 1240580251);
            n4 = this.FF_5(n4, n3, n10, n9, n8, n7, n6, n5, this.X[28], 122909385);
            n3 = this.FF_5(n3, n10, n9, n8, n7, n6, n5, n4, this.X[24], -2137449605);
            n10 = this.FF_5(n10, n9, n8, n7, n6, n5, n4, n3, this.X[2], 634681816);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n10, this.X[23], -152510729);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n10, n9, this.X[16], -469872614);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n10, n9, n8, this.X[22], -1233564613);
            n6 = this.FF_5(n6, n5, n4, n3, n10, n9, n8, n7, this.X[4], -1754472259);
            n5 = this.FF_5(n5, n4, n3, n10, n9, n8, n7, n6, this.X[1], 79693498);
            n4 = this.FF_5(n4, n3, n10, n9, n8, n7, n6, n5, this.X[25], -1045868618);
            n3 = this.FF_5(n3, n10, n9, n8, n7, n6, n5, n4, this.X[15], 1084186820);
        }
        this.context[0] = this.context[0] + n3;
        this.context[1] = this.context[1] + n4;
        this.context[2] = this.context[2] + n5;
        this.context[3] = this.context[3] + n6;
        this.context[4] = this.context[4] + n7;
        this.context[5] = this.context[5] + n8;
        this.context[6] = this.context[6] + n9;
        this.context[7] = this.context[7] + n10;
    }

    private void tailorDigestBits() {
        if (this.bitLength == 128) {
            int n2 = this.context[7] & 0xFF | this.context[6] & 0xFF000000 | this.context[5] & 0xFF0000 | this.context[4] & 0xFF00;
            this.context[0] = this.context[0] + (n2 >>> 8 | n2 << 24);
            n2 = this.context[7] & 0xFF00 | this.context[6] & 0xFF | this.context[5] & 0xFF000000 | this.context[4] & 0xFF0000;
            this.context[1] = this.context[1] + (n2 >>> 16 | n2 << 16);
            n2 = this.context[7] & 0xFF0000 | this.context[6] & 0xFF00 | this.context[5] & 0xFF | this.context[4] & 0xFF000000;
            this.context[2] = this.context[2] + (n2 >>> 24 | n2 << 8);
            n2 = this.context[7] & 0xFF000000 | this.context[6] & 0xFF0000 | this.context[5] & 0xFF00 | this.context[4] & 0xFF;
            this.context[3] = this.context[3] + n2;
        } else if (this.bitLength == 160) {
            int n3 = this.context[7] & 0x3F | this.context[6] & 0xFE000000 | this.context[5] & 0x1F80000;
            this.context[0] = this.context[0] + (n3 >>> 19 | n3 << 13);
            n3 = this.context[7] & 0xFC0 | this.context[6] & 0x3F | this.context[5] & 0xFE000000;
            this.context[1] = this.context[1] + (n3 >>> 25 | n3 << 7);
            n3 = this.context[7] & 0x7F000 | this.context[6] & 0xFC0 | this.context[5] & 0x3F;
            this.context[2] = this.context[2] + n3;
            n3 = this.context[7] & 0x1F80000 | this.context[6] & 0x7F000 | this.context[5] & 0xFC0;
            this.context[3] = this.context[3] + (n3 >>> 6);
            n3 = this.context[7] & 0xFE000000 | this.context[6] & 0x1F80000 | this.context[5] & 0x7F000;
            this.context[4] = this.context[4] + (n3 >>> 12);
        } else if (this.bitLength == 192) {
            int n4 = this.context[7] & 0x1F | this.context[6] & 0xFC000000;
            this.context[0] = this.context[0] + (n4 >>> 26 | n4 << 6);
            n4 = this.context[7] & 0x3E0 | this.context[6] & 0x1F;
            this.context[1] = this.context[1] + n4;
            n4 = this.context[7] & 0xFC00 | this.context[6] & 0x3E0;
            this.context[2] = this.context[2] + (n4 >>> 5);
            n4 = this.context[7] & 0x1F0000 | this.context[6] & 0xFC00;
            this.context[3] = this.context[3] + (n4 >>> 10);
            n4 = this.context[7] & 0x3E00000 | this.context[6] & 0x1F0000;
            this.context[4] = this.context[4] + (n4 >>> 16);
            n4 = this.context[7] & 0xFC000000 | this.context[6] & 0x3E00000;
            this.context[5] = this.context[5] + (n4 >>> 21);
        } else if (this.bitLength == 224) {
            this.context[0] = this.context[0] + (this.context[7] >>> 27 & 0x1F);
            this.context[1] = this.context[1] + (this.context[7] >>> 22 & 0x1F);
            this.context[2] = this.context[2] + (this.context[7] >>> 18 & 0xF);
            this.context[3] = this.context[3] + (this.context[7] >>> 13 & 0x1F);
            this.context[4] = this.context[4] + (this.context[7] >>> 9 & 0xF);
            this.context[5] = this.context[5] + (this.context[7] >>> 4 & 0x1F);
            this.context[6] = this.context[6] + (this.context[7] & 0xF);
        }
    }

    private int FF_1(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.passes) {
            case 3: {
                n11 = this.f_1(n8, n9, n6, n4, n3, n7, n5);
                break;
            }
            case 4: {
                n11 = this.f_1(n7, n3, n8, n5, n4, n6, n9);
                break;
            }
            default: {
                n11 = this.f_1(n6, n5, n8, n9, n4, n7, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n2 >>> 11 | n2 << 21) + n10;
    }

    private int FF_2(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.passes) {
            case 3: {
                n12 = this.f_2(n5, n7, n8, n9, n4, n6, n3);
                break;
            }
            case 4: {
                n12 = this.f_2(n6, n4, n7, n9, n8, n3, n5);
                break;
            }
            default: {
                n12 = this.f_2(n3, n7, n8, n9, n6, n5, n4);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int FF_3(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.passes) {
            case 3: {
                n12 = this.f_3(n3, n8, n7, n6, n5, n4, n9);
                break;
            }
            case 4: {
                n12 = this.f_3(n8, n5, n6, n3, n9, n7, n4);
                break;
            }
            default: {
                n12 = this.f_3(n7, n3, n9, n5, n6, n8, n4);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int FF_4(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.passes) {
            case 4: {
                n12 = this.f_4(n3, n5, n9, n4, n7, n8, n6);
                break;
            }
            default: {
                n12 = this.f_4(n8, n4, n6, n7, n9, n5, n3);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int FF_5(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12 = this.f_5(n7, n4, n9, n3, n5, n6, n8);
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int f_1(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n7 & (n8 ^ n4) ^ n6 & n3 ^ n5 & n2 ^ n8;
    }

    private int f_2(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n6 & (n7 & ~n5 ^ n4 & n3 ^ n2 ^ n8) ^ n4 & (n7 ^ n3) ^ n5 & n3 ^ n8;
    }

    private int f_3(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n5 & (n7 & n6 ^ n2 ^ n8) ^ n7 & n4 ^ n6 & n3 ^ n8;
    }

    private int f_4(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n4 & (n3 & ~n6 ^ n5 & ~n2 ^ n7 ^ n2 ^ n8) ^ n5 & (n7 & n6 ^ n3 ^ n2) ^ n6 & n2 ^ n8;
    }

    private int f_5(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n8 & (n7 & n6 & n5 ^ ~n3) ^ n7 & n4 ^ n6 & n3 ^ n5 & n2;
    }

    public HAVAL() {
        super("HAVAL");
        int n2;
        String string;
        try {
            string = Security.getAlgorithmProperty("HAVAL", "passes");
            n2 = Integer.parseInt(string);
            if (n2 >= 3 && n2 <= 5) {
                this.passes = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = Security.getAlgorithmProperty("HAVAL", "bitLength");
            n2 = Integer.parseInt(string);
            if (n2 % 32 == 0 && n2 >= 128 && n2 <= 256) {
                this.bitLength = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engineReset();
        this.link();
    }

    private HAVAL(HAVAL hAVAL) {
        this();
        this.passes = hAVAL.passes;
        this.bitLength = hAVAL.bitLength;
        this.count = hAVAL.count;
        this.context = (int[])hAVAL.context.clone();
        this.buffer = (byte[])hAVAL.buffer.clone();
    }
}

