/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.MessageDigest;

public class RIPEMD128
extends MessageDigest
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static int debuglevel = Debug.getLevel("RIPEMD128");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("RIPEMD", 2, 3);
    private static final int BLOCK_LENGTH = 64;
    private static final int CONTEXT_LENGTH = 4;
    private static final int[] R = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2};
    private static final int[] Rp = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14};
    private static final int[] S = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12};
    private static final int[] Sp = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8};
    private boolean native_ok;
    private int[] context = new int[4];
    private long count;
    private byte[] buffer = new byte[64];
    private int[] X = new int[16];

    private static void debug(String string) {
        err.println("RIPEMD128: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(RIPEMD128.getLibMajorVersion(), RIPEMD128.getLibMinorVersion());
                    }
                    if (linkStatus.useNative()) {
                        this.native_ok = true;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    RIPEMD128.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                RIPEMD128.debug("Using native library? " + this.native_ok);
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private static native String native_hash(int[] var0, byte[] var1, int var2);

    public Object clone() {
        return new RIPEMD128(this);
    }

    protected void engineReset() {
        this.context[0] = 1732584193;
        this.context[1] = -271733879;
        this.context[2] = -1732584194;
        this.context[3] = 271733878;
        this.count = 0L;
        int n2 = 0;
        while (n2 < 64) {
            this.buffer[n2] = 0;
            ++n2;
        }
    }

    protected void engineUpdate(byte by) {
        int n2 = (int)(this.count % 64L);
        ++this.count;
        this.buffer[n2] = by;
        if (n2 == 63) {
            this.transform(this.buffer, 0);
        }
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || (long)n2 + (long)n3 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = (int)(this.count % 64L);
        this.count += (long)n3;
        int n5 = 64 - n4;
        int n6 = 0;
        if (n3 >= n5) {
            System.arraycopy(byArray, n2, this.buffer, n4, n5);
            this.transform(this.buffer, 0);
            n6 = n5;
            while (n6 + 64 - 1 < n3) {
                this.transform(byArray, n2 + n6);
                n6 += 64;
            }
            n4 = 0;
        }
        if (n6 < n3) {
            System.arraycopy(byArray, n2 + n6, this.buffer, n4, n3 - n6);
        }
    }

    protected byte[] engineDigest() {
        int n2 = (int)(this.count % 64L);
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        byte[] byArray = new byte[n3 + 8];
        byArray[0] = -128;
        int n4 = 0;
        while (n4 < 8) {
            byArray[n3 + n4] = (byte)(this.count * 8L >>> 8 * n4);
            ++n4;
        }
        this.engineUpdate(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[16];
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 4) {
                byArray2[n5 * 4 + n6] = (byte)(this.context[n5] >>> 8 * n6 & 0xFF);
                ++n6;
            }
            ++n5;
        }
        this.engineReset();
        return byArray2;
    }

    protected int engineGetDigestLength() {
        return 16;
    }

    private void transform(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.native_ok) {
            if (this.context.length != 4 || n2 < 0 || (long)n2 + 64L > (long)byArray.length) {
                throw new InternalError(this.getAlgorithm() + ": context.length != " + "4" + " || offset < 0 || " + "(long)offset + " + "64" + " > block.length");
            }
            linkStatus.check(RIPEMD128.native_hash(this.context, byArray, n2));
            return;
        }
        int n9 = 0;
        while (n9 < 16) {
            this.X[n9] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            ++n9;
        }
        int n10 = n8 = this.context[0];
        int n11 = n7 = this.context[1];
        int n12 = n6 = this.context[2];
        int n13 = n5 = this.context[3];
        n9 = 0;
        while (n9 < 16) {
            n4 = S[n9];
            n3 = n10 + (n11 ^ n12 ^ n13) + this.X[n9];
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = Sp[n9];
            n3 = n8 + (n7 & n5 | n6 & ~n5) + this.X[Rp[n9]] + 1352829926;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
            ++n9;
        }
        n9 = 16;
        while (n9 < 32) {
            n4 = S[n9];
            n3 = n10 + (n11 & n12 | ~n11 & n13) + this.X[R[n9]] + 1518500249;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = Sp[n9];
            n3 = n8 + ((n7 | ~n6) ^ n5) + this.X[Rp[n9]] + 1548603684;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
            ++n9;
        }
        n9 = 32;
        while (n9 < 48) {
            n4 = S[n9];
            n3 = n10 + ((n11 | ~n12) ^ n13) + this.X[R[n9]] + 1859775393;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = Sp[n9];
            n3 = n8 + (n7 & n6 | ~n7 & n5) + this.X[Rp[n9]] + 1836072691;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
            ++n9;
        }
        n9 = 48;
        while (n9 < 64) {
            n4 = S[n9];
            n3 = n10 + (n11 & n13 | n12 & ~n13) + this.X[R[n9]] + -1894007588;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = Sp[n9];
            n3 = n8 + (n7 ^ n6 ^ n5) + this.X[Rp[n9]];
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
            ++n9;
        }
        n3 = this.context[1] + n12 + n5;
        this.context[1] = this.context[2] + n13 + n8;
        this.context[2] = this.context[3] + n10 + n7;
        this.context[3] = this.context[0] + n11 + n6;
        this.context[0] = n3;
    }

    public RIPEMD128() {
        super("RIPEMD128");
        this.engineReset();
        this.link();
    }

    private RIPEMD128(RIPEMD128 rIPEMD128) {
        this();
        this.context = (int[])rIPEMD128.context.clone();
        this.buffer = (byte[])rIPEMD128.buffer.clone();
        this.count = rIPEMD128.count;
    }
}

