/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import cryptix.util.core.ArrayUtil;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class PCBC
extends FeedbackMode {
    private byte[] xorBlock;

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("PCBC: IV is not set");
        }
        if (n3 <= 0) {
            return 0;
        }
        switch (this.getState()) {
            case 1: {
                int n5 = 0;
                while (n5 < this.length) {
                    int n6 = n5;
                    this.ivBlock[n6] = (byte)(this.ivBlock[n6] ^ byArray[n2 + n5]);
                    int n7 = n5;
                    this.xorBlock[n7] = (byte)(this.xorBlock[n7] ^ this.ivBlock[n5]);
                    ++n5;
                }
                this.cipher.update(this.xorBlock, 0, this.length, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, byArray2, n4, this.length);
                System.arraycopy(byArray, n2, this.xorBlock, 0, this.length);
                break;
            }
            case 2: {
                this.cipher.update(byArray, n2, this.length, this.xorBlock, 0);
                int n8 = 0;
                while (n8 < this.length) {
                    byArray2[n4 + n8] = (byte)(this.ivBlock[n8] ^ this.xorBlock[n8]);
                    this.ivBlock[n8] = (byte)(byArray[n2 + n8] ^ byArray2[n4 + n8]);
                    ++n8;
                }
                break;
            }
            default: {
                throw new CryptixException("PCBC: Cipher not initialized");
            }
        }
        return this.length;
    }

    public PCBC() {
        super(false, false, "Cryptix");
    }

    public PCBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public PCBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }
}

