/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.math;

import cryptix.util.core.ArrayUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class BigRegister
implements Cloneable,
Serializable {
    public static final int MAXIMUM_SIZE = 4096;
    private static final byte[] log2x = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] high = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final byte[] low = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final String[] binaryDigits = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static final String m_1 = "size < 2";
    private static final String m_2 = "size > MAXIMUM_SIZE";
    private static final SecureRandom prng = new SecureRandom();
    private static final long serialVersionUID = 2535877383275048954L;
    private byte[] bits;
    private int size;

    public synchronized Object clone() {
        return new BigRegister(this);
    }

    public synchronized void and(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = (byte)(this.bits[n3] & bigRegister.bits[n2]);
            ++n2;
        }
    }

    public synchronized void andNot(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = (byte)(this.bits[n3] & ~bigRegister.bits[n2]);
            ++n2;
        }
    }

    public synchronized void or(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = (byte)(this.bits[n3] | bigRegister.bits[n2]);
            ++n2;
        }
        this.pad();
    }

    public synchronized void not() {
        int n2 = 0;
        while (n2 < this.bits.length) {
            this.bits[n2] = ~this.bits[n2];
            ++n2;
        }
        this.pad();
    }

    public synchronized void xor(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = (byte)(this.bits[n3] ^ bigRegister.bits[n2]);
            ++n2;
        }
        this.pad();
    }

    public synchronized void shiftLeft(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftRight(-n2);
            return;
        }
        if (n2 >= this.size) {
            this.reset();
            return;
        }
        int n3 = this.lowestSetBit();
        if (n3 == -1) {
            return;
        }
        if (n3 >= this.size - n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.bits.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.bits, 0, byArray, n3, n5 - n3);
        } else {
            int n6 = 8 - n4;
            int n7 = n3;
            int n8 = 0;
            while (n7 < n5) {
                byArray[n7] = (byte)(this.bits[n8] << n4 | (n8 == 0 ? 0 : (this.bits[n8 - 1] & 0xFF) >>> n6));
                ++n7;
                ++n8;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public synchronized void shiftRight(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftLeft(-n2);
            return;
        }
        if (n2 >= this.size) {
            this.reset();
            return;
        }
        int n3 = this.highestSetBit();
        if (n3 < 0) {
            return;
        }
        if (n3 < n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.bits.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.bits, n3, byArray, 0, n5 - n3);
        } else {
            int n6 = 0;
            int n7 = n3;
            while (n6 < n5 && n7 < n5) {
                byArray[n6] = (byte)(((n7 == n5 - 1 ? 0 : this.bits[n7 + 1] << 8) | this.bits[n7] & 0xFF) >>> n4);
                ++n6;
                ++n7;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public synchronized void rotateLeft(int n2) {
        if ((n2 %= this.size) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateRight(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftRight(this.size - n2);
            this.shiftLeft(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void rotateRight(int n2) {
        if ((n2 %= this.size) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateLeft(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftLeft(this.size - n2);
            this.shiftRight(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void invertOrder() {
        byte[] byArray = new byte[this.bits.length];
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 < this.size) {
            if (this.testBit(n2)) {
                int n4 = n3 / 8;
                byArray[n4] = (byte)(byArray[n4] | 1 << n3 % 8);
            }
            ++n2;
            --n3;
        }
        this.bits = byArray;
    }

    public synchronized boolean testBit(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n2 / 8] & 1 << n2 % 8) != 0;
    }

    public synchronized boolean isSameValue(BigRegister bigRegister) {
        if (bigRegister.size != this.size) {
            return false;
        }
        return ArrayUtil.areEqual(this.bits, bigRegister.bits);
    }

    public synchronized int compareTo(BigRegister bigRegister) {
        if (this.size > bigRegister.size) {
            return 1;
        }
        if (this.size < bigRegister.size) {
            return -1;
        }
        return ArrayUtil.compared(this.bits, bigRegister.bits, true);
    }

    public synchronized void setBit(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.bits[n3] = (byte)(this.bits[n3] | 1 << n2 % 8);
    }

    public synchronized void setBits(int n2, int n3, long l2) {
        if (n2 < 0 || n2 > this.size || n3 < 1 || n3 > 64 || n2 + n3 > this.size) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            if ((l2 & 1L) == 1L) {
                int n6 = n5 / 8;
                this.bits[n6] = (byte)(this.bits[n6] | 1 << n5 % 8);
            }
            l2 >>>= 1;
            ++n4;
            ++n5;
        }
    }

    public synchronized void clearBit(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.bits[n3] = (byte)(this.bits[n3] & ~(1 << n2 % 8));
    }

    public synchronized void flipBit(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.bits[n3] = (byte)(this.bits[n3] ^ 1 << n2 % 8);
    }

    public synchronized int getBit(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n2 / 8] & 0xFF) >> n2 % 8 & 1;
    }

    public synchronized long getBits(int n2, int n3) {
        if (n2 < 0 || n2 > this.size || n3 < 1 || n3 > 64 || n2 + n3 > this.size) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n4 = 0;
        int n5 = n2 + n3 - 1;
        while (n4 < n3) {
            l2 = l2 << 1 | (long)((this.bits[n5 / 8] & 0xFF) >> n5 % 8 & 1);
            ++n4;
            --n5;
        }
        return l2;
    }

    public synchronized int byteValue() {
        return this.bits[0] & 0xFF;
    }

    public synchronized int intValue() {
        int n2 = 0;
        int n3 = this.bits[n2++] & 0xFF;
        try {
            n3 |= (this.bits[n2++] & 0xFF) << 8 | (this.bits[n2++] & 0xFF) << 16 | (this.bits[n2] & 0xFF) << 24;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return n3;
    }

    public synchronized long longValue() {
        int n2 = 0;
        long l2 = (long)this.bits[n2++] & 0xFFL;
        try {
            l2 |= ((long)this.bits[n2++] & 0xFFL) << 8 | ((long)this.bits[n2++] & 0xFFL) << 16 | ((long)this.bits[n2++] & 0xFFL) << 24 | ((long)this.bits[n2++] & 0xFFL) << 32 | ((long)this.bits[n2++] & 0xFFL) << 40 | ((long)this.bits[n2++] & 0xFFL) << 48 | ((long)this.bits[n2] & 0xFFL) << 56;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return l2;
    }

    public synchronized BigRegister valueOf(long l2) {
        BigRegister bigRegister = new BigRegister(this.size);
        int n2 = Math.min(8, this.bits.length);
        int n3 = 0;
        while (n3 < n2) {
            bigRegister.bits[n3] = (byte)(l2 >>> 8 * n3);
            ++n3;
        }
        bigRegister.pad();
        return bigRegister;
    }

    public synchronized void reset() {
        ArrayUtil.clear(this.bits);
    }

    public synchronized void atRandom() {
        this.atRandom(prng);
    }

    public synchronized void atRandom(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.bits);
        this.pad();
    }

    public synchronized void load(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(bigRegister.bits, 0, this.bits, 0, this.bits.length);
    }

    public synchronized void load(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = this.bits.length;
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray, 0, this.bits, 0, n2);
        if (n2 < n3) {
            ArrayUtil.clear(this.bits, n2, n3 - n2);
        }
        this.pad();
    }

    public synchronized byte[] toByteArray() {
        return (byte[])this.bits.clone();
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int countSetBits() {
        int n2 = 0;
        int n3 = this.bits.length;
        int n4 = 0;
        while (n4 < n3) {
            byte by = this.bits[n4];
            n2 += by < 0 ? 8 : log2x[by & 0xFF];
            ++n4;
        }
        return n2;
    }

    public synchronized int highestSetBit() {
        int n2 = this.bits.length - 1;
        while (n2 > 0 && this.bits[n2] == 0) {
            --n2;
        }
        if (this.bits[n2] == 0) {
            return -1;
        }
        int n3 = this.bits[n2] >>> 4 & 0xF;
        int n4 = 4;
        if (n3 == 0) {
            n3 = this.bits[n2] & 0xF;
            n4 -= 4;
        }
        return n2 * 8 + (n4 += high[n3]);
    }

    public synchronized int lowestSetBit() {
        int n2 = 0;
        int n3 = this.bits.length;
        while (n2 < n3 && this.bits[n2] == 0) {
            ++n2;
        }
        if (n2 == n3) {
            return -1;
        }
        int n4 = this.bits[n2] & 0xF;
        int n5 = 0;
        if (n4 == 0) {
            n4 = this.bits[n2] >>> 4 & 0xF;
            n5 += 4;
        }
        return n2 * 8 + (n5 += low[n4]);
    }

    public synchronized String toString() {
        int n2;
        int n3;
        String string;
        StringBuffer stringBuffer = new StringBuffer(8 * this.bits.length + 64);
        stringBuffer.append("Binary dump of a BigRegister [").append(this.size).append("-bit]...\n");
        stringBuffer.append("Byte #:|........|........|........|........|........|........|........|........|\n");
        int n4 = this.bits.length;
        int n5 = n4-- % 8;
        if (n5 != 0) {
            string = "      " + String.valueOf(this.bits.length);
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            n3 = 0;
            while (n3 < 8 - n5) {
                stringBuffer.append("         ");
                ++n3;
            }
            n3 = 0;
            while (n3 < n5) {
                n2 = this.bits[n4--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n2 >>> 4 & 0xF]).append(binaryDigits[n2 & 0xF]);
                ++n3;
            }
            stringBuffer.append('\n');
        }
        int n6 = (n4 + 1) / 8;
        n3 = 0;
        while (n3 < n6) {
            string = "      " + String.valueOf(8 * (n6 - n3));
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            int n7 = 0;
            while (n7 < 8) {
                n2 = this.bits[n4--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n2 >>> 4 & 0xF]).append(binaryDigits[n2 & 0xF]);
                ++n7;
            }
            stringBuffer.append('\n');
            ++n3;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private synchronized void pad() {
        int n2 = 8 - this.size % 8;
        if (n2 != 8) {
            int n3 = this.bits.length - 1;
            this.bits[n3] = (byte)(this.bits[n3] & 255 >>> n2);
        }
    }

    public BigRegister(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException(m_1);
        }
        if (n2 > 4096) {
            throw new IllegalArgumentException(m_2);
        }
        this.size = n2;
        this.bits = new byte[(n2 + 7) / 8];
    }

    private BigRegister(BigRegister bigRegister) {
        this.size = bigRegister.size;
        this.bits = (byte[])bigRegister.bits.clone();
    }
}

