/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.Support;

public class KeyGenerator {
    private final KeyGeneratorSpi spi;
    private final Provider provider;
    private final String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.spi = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final SecretKey generateKey() {
        return this.spi.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Object[] objectArray = Support.getImplementation("KeyGenerator", string);
        return new KeyGenerator((KeyGeneratorSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = Support.getImplementation("KeyGenerator", string, string2);
        return new KeyGenerator((KeyGeneratorSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n2) {
        this.spi.engineInit(n2, new SecureRandom());
    }

    public final void init(int n2, SecureRandom secureRandom) {
        this.spi.engineInit(n2, secureRandom);
    }

    public final void init(SecureRandom secureRandom) {
        this.spi.engineInit(secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(algorithmParameterSpec, secureRandom);
    }
}

