/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.Support;

public class SecretKeyFactory {
    private final SecretKeyFactorySpi spi;
    private final Provider provider;
    private final String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.spi = secretKeyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.spi.engineGenerateSecret(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        Object[] objectArray = Support.getImplementation("SecretKeyFactory", string);
        return new SecretKeyFactory((SecretKeyFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = Support.getImplementation("SecretKeyFactory", string, string2);
        return new SecretKeyFactory((SecretKeyFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.spi.engineGetKeySpec(secretKey, clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.spi.engineTranslateKey(secretKey);
    }
}

