/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -7156603696948215014L;
    private AttributeValueExp exp;
    private String pattern;

    public MatchQueryExp() {
    }

    public MatchQueryExp(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        this.exp = attributeValueExp;
        this.pattern = stringValueExp.getValue();
    }

    public AttributeValueExp getAttribute() {
        return this.exp;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp.apply(objectName);
        if (!(valueExp instanceof StringValueExp)) {
            return false;
        }
        return MatchQueryExp.wildmatch(((StringValueExp)valueExp).getValue(), this.pattern);
    }

    public String toString() {
        return this.exp + " like " + new StringValueExp(MatchQueryExp.likeTranslate(this.pattern));
    }

    private static String likeTranslate(String string) {
        return string.replace('?', '_').replace('*', '%');
    }

    private static boolean wildmatch(String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = string2.length();
        while (n3 < n5) {
            char c2;
            if ((c2 = string2.charAt(n3++)) == '?') {
                if (++n2 <= n4) continue;
                return false;
            }
            if (c2 == '[') {
                boolean bl = true;
                boolean bl2 = false;
                if (string2.charAt(n3) == '!') {
                    bl = false;
                    ++n3;
                }
                while (++n3 < n5 && (c2 = string2.charAt(n3)) != ']') {
                    if (string2.charAt(n3) == '-' && n3 + 1 < n5) {
                        if (string.charAt(n2) >= c2 && string.charAt(n2) <= string2.charAt(n3 + 1)) {
                            bl2 = true;
                        }
                        ++n3;
                        continue;
                    }
                    if (c2 != string.charAt(n2)) continue;
                    bl2 = true;
                }
                if (n3 >= n5 || bl != bl2) {
                    return false;
                }
                ++n3;
                ++n2;
                continue;
            }
            if (c2 == '*') {
                if (n3 >= n5) {
                    return true;
                }
                do {
                    if (!MatchQueryExp.wildmatch(string.substring(n2), string2.substring(n3))) continue;
                    return true;
                } while (++n2 < n4);
                return false;
            }
            if (!(c2 == '\\' ? n3 >= n5 || string2.charAt(n3++) != string.charAt(n2++) : n2 >= n4 || c2 != string.charAt(n2++))) continue;
            return false;
        }
        return n2 == n4;
    }
}

