/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import mx4j.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetAttributeCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String name = in.getVariable("objectname");
        String attributeVariable = in.getVariable("attribute");
        String formatVariable = in.getVariable("format");
        ObjectName objectName = null;
        MBeanAttributeInfo targetAttribute = null;
        boolean validMBean = false;
        if (name != null && this.server.isRegistered(objectName = new ObjectName(name))) {
            validMBean = true;
        }
        if (validMBean && attributeVariable != null) {
            validMBean = false;
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            if (attributes != null) {
                int i2 = 0;
                while (i2 < attributes.length) {
                    if (attributes[i2].getName().equals(attributeVariable)) {
                        targetAttribute = attributes[i2];
                        validMBean = true;
                        break;
                    }
                    ++i2;
                }
            }
        }
        if (validMBean) {
            Element root = document.createElement("MBean");
            document.appendChild(root);
            root.setAttribute("objectname", objectName.toString());
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            root.setAttribute("classname", info.getClassName());
            root.setAttribute("description", info.getDescription());
            Element attribute = document.createElement("Attribute");
            attribute.setAttribute("name", attributeVariable);
            attribute.setAttribute("classname", targetAttribute.getType());
            Object attributeValue = this.server.getAttribute(objectName, attributeVariable);
            attribute.setAttribute("isnull", attributeValue == null ? "true" : "false");
            root.appendChild(attribute);
            if ("array".equals(formatVariable) && attributeValue.getClass().isArray()) {
                Element array = document.createElement("Array");
                array.setAttribute("componentclass", attributeValue.getClass().getComponentType().getName());
                int length = Array.getLength(attributeValue);
                array.setAttribute("length", "" + length);
                int i3 = 0;
                while (i3 < length) {
                    Element arrayElement = document.createElement("Element");
                    arrayElement.setAttribute("index", "" + i3);
                    if (Array.get(attributeValue, i3) != null) {
                        arrayElement.setAttribute("element", Array.get(attributeValue, i3).toString());
                        arrayElement.setAttribute("isnull", "false");
                    } else {
                        arrayElement.setAttribute("element", "null");
                        arrayElement.setAttribute("isnull", "true");
                    }
                    array.appendChild(arrayElement);
                    ++i3;
                }
                attribute.appendChild(array);
            } else if ("collection".equals(formatVariable) && attributeValue instanceof Collection) {
                Collection collection = (Collection)attributeValue;
                Element collectionElement = document.createElement("Collection");
                collectionElement.setAttribute("length", "" + collection.size());
                Iterator i4 = collection.iterator();
                int j2 = 0;
                while (i4.hasNext()) {
                    Element collectionEntry = document.createElement("Element");
                    collectionEntry.setAttribute("index", "" + j2++);
                    Object obj = i4.next();
                    if (obj != null) {
                        collectionEntry.setAttribute("elementclass", obj.getClass().getName());
                        collectionEntry.setAttribute("element", obj.toString());
                    } else {
                        collectionEntry.setAttribute("elementclass", "null");
                        collectionEntry.setAttribute("element", "null");
                    }
                    collectionElement.appendChild(collectionEntry);
                }
                attribute.appendChild(collectionElement);
            } else if ("map".equals(formatVariable) && attributeValue instanceof Map) {
                Map map = (Map)attributeValue;
                Element mapElement = document.createElement("Map");
                mapElement.setAttribute("length", "" + map.size());
                Iterator i5 = map.keySet().iterator();
                int j3 = 0;
                while (i5.hasNext()) {
                    Element mapEntry = document.createElement("Element");
                    mapEntry.setAttribute("index", "" + j3++);
                    Object key = i5.next();
                    Object entry = map.get(key);
                    if (entry != null && key != null) {
                        mapEntry.setAttribute("keyclass", key.getClass().getName());
                        mapEntry.setAttribute("key", key.toString());
                        mapEntry.setAttribute("elementclass", entry.getClass().getName());
                        mapEntry.setAttribute("element", entry.toString());
                    } else {
                        mapEntry.setAttribute("keyclass", "null");
                        mapEntry.setAttribute("key", "null");
                        mapEntry.setAttribute("elementclass", "null");
                        mapEntry.setAttribute("element", "null");
                    }
                    mapElement.appendChild(mapEntry);
                }
                attribute.appendChild(mapElement);
            } else {
                attribute.setAttribute("value", attributeValue.toString());
            }
        }
        return document;
    }
}

