/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.adaptor.http.XSLTProcessorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Document;

public class XSLTProcessor
implements ProcessorMBean,
XSLTProcessorMBean,
URIResolver {
    TransformerFactory factory = null;
    private Map templatesCache = new HashMap();
    private static final String ENCODING = "UTF-8";
    private String path = "mx4j/adaptor/http/xsl";
    private File root = null;
    private Map mimeTypes = new HashMap();
    private boolean useJar = true;
    private boolean useCache = true;
    private ClassLoader targetClassLoader = ClassLoader.getSystemClassLoader();
    private String defaultPage = "serverbydomain";
    private Locale locale = new Locale("en", "");

    public XSLTProcessor() {
        this.factory = TransformerFactory.newInstance();
        this.factory.setURIResolver(this);
        this.mimeTypes.put(".gif", "image/gif");
        this.mimeTypes.put(".jpg", "image/jpg");
        this.mimeTypes.put(".png", "image/png");
        this.mimeTypes.put(".tif", "image/tiff");
        this.mimeTypes.put(".tiff", "image/tiff");
        this.mimeTypes.put(".html", "text/html");
        this.mimeTypes.put(".htm", "text/html");
        this.mimeTypes.put(".txt", "text/plain");
        this.mimeTypes.put(".xml", "text/xml");
        this.mimeTypes.put(".xsl", "text/xsl");
        this.mimeTypes.put(".css", "text/css");
        this.mimeTypes.put(".js", "text/x-javascript");
        this.mimeTypes.put(".jar", "application/java-archive");
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        Logger log = this.getLogger();
        out.setCode(200);
        out.setHeader("Content-Type", "text/html");
        out.setHeader("Cache-Control", "no-cache");
        out.setHeader("expires", "now");
        out.setHeader("pragma", "no-cache");
        out.sendHeaders();
        Transformer transformer = null;
        String path = this.preProcess(in.getPath());
        transformer = in.getVariable("template") != null ? this.createTransformer(in.getVariable("template") + ".xsl") : this.createTransformer(path + ".xsl");
        if (transformer != null) {
            transformer.setURIResolver(this);
            Map variables = in.getVariables();
            Iterator j2 = variables.keySet().iterator();
            while (j2.hasNext()) {
                String key = (String)j2.next();
                Object value = variables.get(key);
                if (value instanceof String) {
                    transformer.setParameter("request." + key, value);
                }
                if (!(value instanceof String[])) continue;
                String[] allvalues = (String[])value;
                transformer.setParameter("request." + key, allvalues[0]);
            }
            if (!variables.containsKey("locale")) {
                transformer.setParameter("request.locale", this.locale.toString());
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                if (log.isEnabledFor(0)) {
                    log.trace("transforming " + path);
                }
                transformer.transform(new DOMSource(document), new StreamResult(output));
                output.writeTo(out);
            }
            catch (TransformerException e2) {
                log.error("Transformation exception ", e2);
            }
        } else {
            log.warn("Transformer for path " + path + " not found");
        }
    }

    protected Transformer createTransformer(String path) {
        Transformer transformer;
        block5: {
            Logger log = this.getLogger();
            transformer = null;
            try {
                if (this.useCache && this.templatesCache.containsKey(path)) {
                    transformer = ((Templates)this.templatesCache.get(path)).newTransformer();
                    break block5;
                }
                InputStream file = this.getInputStream(path);
                if (file != null) {
                    if (log.isEnabledFor(20)) {
                        log.info("Creating template for path " + path);
                    }
                    Templates template = this.factory.newTemplates(new StreamSource(file));
                    transformer = template.newTransformer();
                    if (!this.useCache) break block5;
                    this.templatesCache.put(path, template);
                    break block5;
                }
                log.warn("template for path " + path + " not found");
            }
            catch (TransformerConfigurationException e2) {
                log.error("Exception during template construction", e2);
            }
        }
        return transformer;
    }

    protected void processHttpException(HttpInputStream in, HttpOutputStream out, HttpException e2) throws IOException {
        block3: {
            out.setCode(e2.getCode());
            out.setHeader("Content-Type", "text/html");
            out.sendHeaders();
            Transformer transformer = this.createTransformer("error.xsl");
            transformer.setURIResolver(this);
            Document doc = e2.getResponseDoc();
            if (doc == null) break block3;
            try {
                if (!in.getVariables().containsKey("locale")) {
                    transformer.setParameter("request.locale", this.locale.toString());
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                transformer.transform(new DOMSource(doc), new StreamResult(output));
                output.writeTo(out);
            }
            catch (TransformerException ex) {
                Logger log = this.getLogger();
                log.error("Exception during error output", ex);
            }
        }
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e2) throws IOException {
        Logger log = this.getLogger();
        Exception t2 = e2;
        if (e2 instanceof RuntimeMBeanException) {
            t2 = ((RuntimeMBeanException)e2).getTargetException();
        }
        if (log.isEnabledFor(20)) {
            log.info("Processing error " + t2.getMessage());
        }
        if (t2 instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)e2);
        } else if (t2 instanceof MBeanException && ((MBeanException)t2).getTargetException() instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)((MBeanException)t2).getTargetException());
        } else if (t2 instanceof ReflectionException && ((ReflectionException)t2).getTargetException() instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)((ReflectionException)t2).getTargetException());
        } else {
            out.setCode(500);
            out.setHeader("Content-Type", "text/html");
            out.sendHeaders();
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/" + this.defaultPage;
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        Logger log = this.getLogger();
        File file = new File(this.path, path);
        if (log.isEnabledFor(20)) {
            log.info("Processing file request " + file);
        }
        String name = file.getName();
        int extensionIndex = name.lastIndexOf(46);
        String mime = null;
        if (extensionIndex < 0) {
            log.warn("Filename has no extensions " + file.toString());
            mime = "text/plain";
        } else {
            String extension = name.substring(extensionIndex, name.length());
            if (this.mimeTypes.containsKey(extension)) {
                mime = (String)this.mimeTypes.get(extension);
            } else {
                log.warn("MIME type not found " + extension);
                mime = "text/plain";
            }
        }
        try {
            if (log.isEnabledFor(10)) {
                log.debug("Trying to read file " + file);
            }
            BufferedInputStream fileIn = new BufferedInputStream(this.getInputStream(path));
            ByteArrayOutputStream outArray = new ByteArrayOutputStream();
            BufferedOutputStream outBuffer = new BufferedOutputStream(outArray);
            int piece = 0;
            while ((piece = fileIn.read()) >= 0) {
                outBuffer.write(piece);
            }
            outBuffer.flush();
            out.setCode(200);
            out.setHeader("Content-type", mime);
            out.sendHeaders();
            if (log.isEnabledFor(10)) {
                log.debug("File output " + mime);
            }
            outArray.writeTo(out);
            fileIn.close();
        }
        catch (Exception e2) {
            log.warn("Exception loading file " + file, e2);
            throw new HttpException(404, "file " + file + " not found");
        }
        return null;
    }

    protected InputStream getInputStream(String path) {
        InputStream file = null;
        if (!this.useJar) {
            try {
                file = new FileInputStream(new File(this.root, path));
            }
            catch (FileNotFoundException e2) {
                Logger log = this.getLogger();
                log.error("File not found", e2);
            }
        } else {
            String targetFile = this.path;
            targetFile = path.startsWith("/") ? targetFile + path : targetFile + "/" + path;
            if (this.root != null) {
                file = this.targetClassLoader.getResourceAsStream(targetFile);
            }
            if (file == null) {
                file = this.getClass().getClassLoader().getResourceAsStream(targetFile);
            }
        }
        return file;
    }

    public Source resolve(String href, String base) {
        StreamSource source = new StreamSource(this.getInputStream(href));
        source.setSystemId(href);
        return source;
    }

    public void setFile(String file) {
        if (file != null) {
            Logger log = this.getLogger();
            File target = new File(file);
            if (!target.exists()) {
                log.warn("Target file " + file + " does not exist, defaulting to previous");
                return;
            }
            if (target.isDirectory()) {
                this.useJar = false;
                if (log.isEnabledFor(20)) {
                    log.info("Using " + file + " as the root dir");
                }
                this.root = target;
                return;
            }
            if (target.isFile() && (target.getName().endsWith(".jar") || target.getName().endsWith(".zip"))) {
                try {
                    URL url = target.toURL();
                    this.targetClassLoader = new URLClassLoader(new URL[]{url});
                    if (log.isEnabledFor(20)) {
                        log.info("Using compressed file " + url + " as the root file");
                    }
                    this.root = target;
                    this.useJar = true;
                }
                catch (MalformedURLException e2) {
                    log.warn("Unable to create class loader", e2);
                }
            } else {
                log.warn("Target file " + file + " does not exist, defaulting to previous");
            }
        }
    }

    public String getFile() {
        return this.root != null ? this.root.getName() : null;
    }

    public String getPathInJar() {
        return this.path;
    }

    public void setPathInJar(String path) {
        this.path = path;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public boolean isUseJar() {
        return this.useJar;
    }

    public boolean isUsePath() {
        return !this.useJar;
    }

    public void addMimeType(String extension, String type) {
        if (extension != null && type != null) {
            Logger log = this.getLogger();
            if (log.isEnabledFor(20)) {
                log.info("Added MIME type " + type + " for extension " + extension);
            }
            this.mimeTypes.put(extension, type);
        }
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public String getName() {
        return "XSLT Processor";
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocaleString(String locale) {
        this.locale = new Locale(locale, "");
    }
}

