/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.interceptor;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import mx4j.ImplementationException;
import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.loading.RepositoryClassLoader;

public class ContextClassLoaderAdaptorInterceptor
extends AdaptorInterceptor {
    private boolean m_isMX4J;
    private Method m_getClassLoader;
    private Method m_getClassLoaderFor;
    private Method m_getClassLoaderRepository;
    private ThreadLocal m_classloader = new ThreadLocal();
    static /* synthetic */ Class class$javax$management$ObjectName;

    public void setMBeanServer(MBeanServer server) {
        block2: {
            super.setMBeanServer(server);
            this.m_isMX4J = this.isMX4JImplementation(server);
            if (!this.m_isMX4J) break block2;
            try {
                this.m_getClassLoader = server.getClass().getMethod("getClassLoader", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ContextClassLoaderAdaptorInterceptor.class$("javax.management.ObjectName")) : class$javax$management$ObjectName);
                this.m_getClassLoaderFor = server.getClass().getMethod("getClassLoaderFor", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ContextClassLoaderAdaptorInterceptor.class$("javax.management.ObjectName")) : class$javax$management$ObjectName);
                this.m_getClassLoaderRepository = server.getClass().getMethod("getClassLoaderRepository", new Class[0]);
            }
            catch (Exception ignored) {}
        }
    }

    public String getType() {
        return "contextclassloader";
    }

    public void setEnabled(boolean value) {
    }

    public boolean isEnabled() {
        return true;
    }

    protected void preInvoke(Invocation invocation) throws Exception {
        if (this.m_isMX4J) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            this.m_classloader.set(old);
            ClassLoader cl = null;
            String key = invocation.getClassLoaderKey();
            if (key != null) {
                if (key.equals("MBeanServer")) {
                    cl = this.getMBeanServer().getClass().getClassLoader();
                } else if (key.equals("ClassLoaderRepository")) {
                    cl = this.getRepositoryClassLoader();
                } else if (key.equals("Loader")) {
                    ObjectName name = invocation.getObjectNameForClassLoader();
                    cl = this.getClassLoader(name);
                } else if (key.equals("MBean")) {
                    ObjectName name = invocation.getObjectNameForClassLoader();
                    cl = this.getClassLoaderFor(name);
                } else {
                    throw new ImplementationException();
                }
            }
            if (cl != null && cl != old) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void postInvoke(Invocation invocation) throws Exception {
        if (this.m_isMX4J) {
            ClassLoader cl = (ClassLoader)this.m_classloader.get();
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private boolean isMX4JImplementation(MBeanServer server) {
        try {
            ClassLoader loader = server.getClass().getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> cls = loader.loadClass("mx4j.server.MBeanServerImpl");
            return cls.isInstance(server);
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private ClassLoader getClassLoader(ObjectName name) {
        try {
            return (ClassLoader)this.m_getClassLoader.invoke((Object)this.getMBeanServer(), name);
        }
        catch (Exception x2) {
            return null;
        }
    }

    private ClassLoader getClassLoaderFor(ObjectName name) {
        try {
            return (ClassLoader)this.m_getClassLoaderFor.invoke((Object)this.getMBeanServer(), name);
        }
        catch (Exception x2) {
            return null;
        }
    }

    private ClassLoader getRepositoryClassLoader() {
        try {
            ClassLoaderRepository clr = (ClassLoaderRepository)this.m_getClassLoaderRepository.invoke((Object)this.getMBeanServer(), new Object[0]);
            return new RepositoryClassLoader(clr);
        }
        catch (Exception x2) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

