/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.log.LoggerBroadcasterMBean;

public class LoggerBroadcaster
extends NotificationBroadcasterSupport
implements MBeanRegistration,
LoggerBroadcasterMBean {
    private long m_sequence;
    private boolean m_registered;
    private int m_recursionLevel;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        this.m_registered = true;
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.m_registered = false;
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification n2) {
        int maxRecursionLevel = 1;
        LoggerBroadcaster loggerBroadcaster = this;
        synchronized (loggerBroadcaster) {
            if (this.m_recursionLevel < maxRecursionLevel) {
                ++this.m_recursionLevel;
                super.sendNotification(n2);
                --this.m_recursionLevel;
            }
        }
    }

    public void start() {
        Logger logger = this.createLoggerPrototype();
        Log.redirectTo(logger);
    }

    public void start(String category) {
        Logger logger = this.createLoggerPrototype();
        Log.redirectTo(logger, category);
    }

    public void stop() {
        Log.redirectTo(null);
    }

    public void stop(String category) {
        Log.redirectTo(null, category);
    }

    private boolean isRegistered() {
        return this.m_registered;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"mx4j.logger.trace", "mx4j.logger.debug", "mx4j.logger.info", "mx4j.logger.warn", "mx4j.logger.error", "mx4j.logger.fatal"};
        MBeanNotificationInfo notifs = new MBeanNotificationInfo(types, "javax.management.Notification", "MX4J Logger MBean notifications");
        return new MBeanNotificationInfo[]{notifs};
    }

    protected Logger createLoggerPrototype() {
        return new LoggerNotifier(this);
    }

    public static class LoggerNotifier
    extends Logger {
        private static LoggerBroadcaster m_loggerBroadcaster;

        private LoggerNotifier(LoggerBroadcaster mbean) {
            m_loggerBroadcaster = mbean;
        }

        public LoggerNotifier() {
        }

        protected void log(int priority, Object message, Throwable t2) {
            this.notify(priority, message, t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notify(int priority, Object message, Throwable t2) {
            if (LoggerNotifier.m_loggerBroadcaster.isRegistered()) {
                long sequence = 0L;
                LoggerNotifier loggerNotifier = this;
                synchronized (loggerNotifier) {
                    sequence = ++m_loggerBroadcaster.m_sequence;
                }
                String type = null;
                switch (priority) {
                    case 0: {
                        type = "mx4j.logger.trace";
                        break;
                    }
                    case 10: {
                        type = "mx4j.logger.debug";
                        break;
                    }
                    case 20: {
                        type = "mx4j.logger.info";
                        break;
                    }
                    case 30: {
                        type = "mx4j.logger.warn";
                        break;
                    }
                    case 40: {
                        type = "mx4j.logger.error";
                        break;
                    }
                    case 50: {
                        type = "mx4j.logger.fatal";
                        break;
                    }
                    default: {
                        type = "mx4j.logger." + priority;
                    }
                }
                String msg = message == null ? "" : message.toString();
                Notification n2 = new Notification(type, (Object)this, sequence, msg);
                if (t2 != null) {
                    n2.setUserData(t2);
                }
                m_loggerBroadcaster.sendNotification(n2);
            }
        }
    }
}

