/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.PrintWriter;
import java.util.Hashtable;
import netscape.security.ForbiddenTargetException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.security.UserDialogHelper;
import netscape.security.UserTarget;
import xjava.lang.IJCE_ClassLoaderDepth;
import xjava.security.IJCE;
import xjava.security.IJCE_Java10Support;
import xjava.security.IJCE_Properties;

class IJCE_SecuritySupport {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("IJCE_SecuritySupport");
    private static PrintWriter err = IJCE.getDebugOutput();
    private static final String TARGET_HELP_FILENAME = "TargetHelp.html";
    private static String targetHelpURL;
    private static PrivilegeManager privMgr;
    private static Hashtable targets;

    private static void debug(String string) {
        err.println("IJCE_SecuritySupport: " + string);
    }

    private static void registerTargets() {
        block14: {
            if (debuglevel >= 4) {
                IJCE_SecuritySupport.debug("Initializing...");
            }
            try {
                Principal principal = null;
                try {
                    Principal[] principalArray = PrivilegeManager.getMyPrincipals();
                    if (principalArray == null || principalArray.length == 0) {
                        err.println("Warning: invalid return value from PrivilegeManager.getMyPrincipals()\nFuture security-related operations will probably fail.");
                        return;
                    }
                    principal = principalArray[0];
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (debuglevel >= 5) {
                    IJCE_SecuritySupport.debug("myPrincipal = " + principal);
                }
                int n2 = UserDialogHelper.targetRiskLow();
                String string = UserDialogHelper.targetRiskColorLow();
                int n3 = UserDialogHelper.targetRiskHigh();
                String string2 = UserDialogHelper.targetRiskColorHigh();
                if (debuglevel >= 5) {
                    IJCE_SecuritySupport.debug("registering security targets...");
                }
                IJCE_SecuritySupport.registerTarget(principal, "AddSecurityProvider", n3, string2);
                IJCE_SecuritySupport.registerTarget(principal, "RemoveSecurityProvider", n3, string2);
                IJCE_SecuritySupport.registerTarget(principal, "SecurityPropertyRead", n2, string);
                IJCE_SecuritySupport.registerTarget(principal, "SecurityPropertyWrite", n3, string2);
                boolean bl = true;
                try {
                    bl = IJCE_Java10Support.isAssignableFrom(Class.forName("java.util.Hashtable"), Class.forName("java.security.Provider"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) {
                    IJCE_SecuritySupport.registerTarget(principal, "GetSecurityProviders", n3, string2);
                } else {
                    IJCE_SecuritySupport.registerTarget(principal, "GetSecurityProviders", n2, string);
                }
                if (debuglevel >= 3) {
                    IJCE_SecuritySupport.debug("All security targets successfully registered.");
                }
            }
            catch (Exception exception) {
                IJCE.debug("Warning: Unable to register security target.");
                exception.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (debuglevel < 1) break block14;
                noClassDefFoundError.printStackTrace();
            }
        }
    }

    private static Target registerTarget(Principal principal, String string, int n2, String string2) {
        String string3 = IJCE_Properties.getProperty("UI.target." + string);
        String string4 = targetHelpURL == null ? null : targetHelpURL + "#" + string;
        try {
            Target target = new UserTarget(string, principal, n2, string2, string3, string4).registerTarget();
            if (debuglevel >= 6) {
                IJCE_SecuritySupport.debug("registering " + target);
            }
            targets.put(string, target);
            return target;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
            return null;
        }
    }

    static Target findTarget(String string) throws ForbiddenTargetException {
        Target target = (Target)targets.get(string);
        if (target != null) {
            return target;
        }
        throw new ForbiddenTargetException("There is no security target with name \"" + string + "\"");
    }

    static Target findTarget(String string, Object object) throws ForbiddenTargetException {
        throw new ForbiddenTargetException("This version of IJCE has no parameterized security targets");
    }

    static void checkPrivilegeEnabled(String string, int n2) {
        IJCE_SecuritySupport.checkPrivilegeEnabled(IJCE_SecuritySupport.findTarget(string), n2 + 1);
    }

    static void checkPrivilegeEnabled(Target target, int n2) {
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        try {
            if (privMgr == null) {
                privMgr = PrivilegeManager.getPrivilegeManager();
            }
            privMgr.checkPrivilegeEnabled(target);
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        IJCE_SecuritySupport.checkSystemCaller(n2 + 1);
    }

    static void checkPrivilegeEnabled(Target target, Object object, int n2) {
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        try {
            if (privMgr == null) {
                privMgr = PrivilegeManager.getPrivilegeManager();
            }
            privMgr.checkPrivilegeEnabled(target, object);
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        IJCE_SecuritySupport.checkSystemCaller(n2 + 1);
    }

    static void checkSystemCaller(int n2) {
        int n3 = IJCE_ClassLoaderDepth.classLoaderDepth();
        if (n3 < 0) {
            return;
        }
        if (n3 <= n2) {
            IJCE.reportBug("incorrect depth passed to IJCE_SecuritySupport.checkSystemCaller:\ndepth = " + n2 + ", classLoaderDepth() = " + n3);
        }
        if (n3 == n2 + 1) {
            throw new SecurityException("this operation cannot be performed from a non-system class");
        }
    }

    private IJCE_SecuritySupport() {
    }

    static {
        targets = new Hashtable();
        targetHelpURL = TARGET_HELP_FILENAME;
        try {
            IJCE_SecuritySupport.registerTargets();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            IJCE.reportBug("Unexpected exception in IJCE_SecuritySupport.registerTargets()");
        }
    }
}

